// Screen Window
#include "app.h"

static char *szClass="Scrn"; // Window class name
HWND hScrnWnd=NULL; // Handle to the screen window

// The Screen window proc
static LRESULT CALLBACK ScrnProc(HWND hWnd,UINT Msg,WPARAM wParam,LPARAM lParam)
{
  if (Msg==WM_PAINT)
  {
    VidPaint(1);  // paint and validate
  }
  if (Msg==WM_CLOSE)
  {
    PostQuitMessage(0);  // Quit the program if the window is closed
    return 0;
  }
  return DefWindowProc(hWnd,Msg,wParam,lParam);
}

// Init the screen window (create it)
int ScrnInit()
{
	WNDCLASS wc;
	RECT rect={0,0,0,0};
	int style=0;
	int left=0,top=0,width=0,height=0;

	memset(&wc,0,sizeof(wc));

	// Register the window class:
	wc.lpfnWndProc=ScrnProc;
	wc.hInstance=GetModuleHandle(NULL);
	wc.hCursor=LoadCursor(NULL,IDC_ARROW);
	wc.hbrBackground=CreateSolidBrush(0);
	wc.lpszClassName="MainFrame";
	RegisterClass(&wc);

	rect.right =640;
	rect.bottom=480;

	// Adjust size of windows based on borders:
	style=WS_OVERLAPPEDWINDOW;
	AdjustWindowRect(&rect,style,0);
	width =rect.right-rect.left;
	height=rect.bottom-rect.top;

	// Place window in the centre of the screen:
	SystemParametersInfo(SPI_GETWORKAREA,0,&rect,0);
	left=rect.left+rect.right;
	top=rect.top+rect.bottom;

	left-=width; left>>=1;
	top-=height; top>>=1;

	// Create the window:
	hScrnWnd=CreateWindow(wc.lpszClassName,"",style|WS_VISIBLE,
		left,top,width,height,NULL,NULL,NULL,NULL);

  return 0;
}
